/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.tools.ModManager;
import net.ftb.util.SwingUtils;

public class ModPackVersionChangeDialog
extends JDialog {
    private JLabel messageLbl;
    private JLabel updateLbl;
    private JTextArea versionLbl;
    private JButton update;
    private JButton abort;
    private JCheckBox backupCFG;
    private JCheckBox backupSave;

    public ModPackVersionChangeDialog(LaunchFrame instance, boolean modal, final String storedVersion, final String onlineVersion) {
        super((Frame)instance, modal);
        this.setupGui(storedVersion, onlineVersion);
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.allowVersionChange = true;
                LaunchFrame.doVersionBackup = ModPackVersionChangeDialog.this.backupCFG.isSelected();
                Settings.getSettings().setPackVer(onlineVersion);
                ModManager.backupSave = ModPackVersionChangeDialog.this.backupSave.isSelected();
                ModPackVersionChangeDialog.this.setVisible(false);
            }
        });
        this.abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.allowVersionChange = false;
                Settings.getSettings().setPackVer(storedVersion);
                ModPackVersionChangeDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui(String storedVersion, String onlineVersion) {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("UPDATEMODPACK_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        if (this.isNewer(onlineVersion, storedVersion)) {
            this.messageLbl = new JLabel(I18N.getLocaleString("UPDATEMODPACK_ISAVALIBLE"));
            this.updateLbl = new JLabel(I18N.getLocaleString("UPDATE_WICHUPDATE"));
        } else {
            this.messageLbl = new JLabel(I18N.getLocaleString("UPDATEMODPACK_DOWNGRADE"));
            this.updateLbl = new JLabel(I18N.getLocaleString("UPDATE_DOWNGRADE"));
        }
        this.versionLbl = new JTextArea(I18N.getLocaleString("UPDATEMODPACK_FROM_TO_VERSION").replace("%LOCALVER%", storedVersion).replace("%ONLINEVER%", onlineVersion));
        this.versionLbl.setEditable(false);
        this.versionLbl.setHighlighter(null);
        this.versionLbl.setBorder(BorderFactory.createEmptyBorder());
        this.update = new JButton(I18N.getLocaleString("MAIN_YES"));
        this.abort = new JButton(I18N.getLocaleString("MAIN_NO"));
        this.backupCFG = new JCheckBox(I18N.getLocaleString("UPDATEMODPACK_BACKUPCFG"));
        this.backupSave = new JCheckBox(I18N.getLocaleString("UPDATEMODPACK_BACKUPSave"));
        this.messageLbl.setHorizontalAlignment(0);
        this.updateLbl.setHorizontalAlignment(0);
        this.backupCFG.setHorizontalAlignment(0);
        this.backupSave.setHorizontalAlignment(0);
        panel.add(this.messageLbl);
        panel.add(this.versionLbl);
        panel.add(this.updateLbl);
        panel.add(this.backupCFG);
        panel.add(this.backupSave);
        panel.add(this.update);
        panel.add(this.abort);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.versionLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.backupCFG, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.backupSave, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.messageLbl), Spring.width(this.updateLbl), Spring.width(this.versionLbl), Spring.width(this.backupCFG), Spring.width(this.backupSave));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.messageLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.updateLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.versionLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.backupCFG, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.backupSave, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.backupCFG, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("HorizontalCenter", (Component)this.backupSave, 0, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.update, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.abort, 5, "HorizontalCenter", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("North", (Component)this.messageLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.messageLbl), Spring.constant(15));
        layout.putConstraint("North", (Component)this.versionLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.versionLbl), Spring.constant(15));
        layout.putConstraint("North", (Component)this.updateLbl, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.updateLbl), Spring.constant(10));
        layout.putConstraint("North", (Component)this.backupCFG, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.backupCFG), Spring.constant(10));
        layout.putConstraint("North", (Component)this.backupSave, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.backupSave), Spring.constant(10));
        layout.putConstraint("North", (Component)this.update, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.abort, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.height(this.update);
        rowHeight = Spring.max(rowHeight, Spring.height(this.abort));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public boolean isNewer(String onlineVersion, String storedVersion) {
        if (storedVersion == null || storedVersion.isEmpty()) {
            return true;
        }
        String[] oV = onlineVersion.split("[._-]");
        String[] sV = storedVersion.split("[._-]");
        Logger.logInfo(onlineVersion + " " + storedVersion);
        for (int i = 0; i < oV.length; ++i) {
            if (sV.length <= i) continue;
            if (Integer.parseInt(oV[i]) > Integer.parseInt(sV[i])) {
                Logger.logInfo(oV[i] + ">" + sV[i]);
                Logger.logInfo("ret true");
                return true;
            }
            if (Integer.parseInt(oV[i]) >= Integer.parseInt(sV[i])) continue;
            return false;
        }
        Logger.logInfo("ret False");
        return false;
    }
}

